/****** Object:  StoredProcedure [CRS].[usp_APPT_APPOINTMENT_getitemsByReferral]    Script Date: 3/12/2018 3:05:25 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_APPT_APPOINTMENT_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_APPT_APPOINTMENT_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_APPT_APPOINTMENT_getitemsByReferral]    Script Date: 3/12/2018 3:05:25 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_APPT_APPOINTMENT_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'



-- =============================================
-- Author:        
-- Create date:   5/7/2018
-- Description:   Get all Appointment records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_APPT_APPOINTMENT_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_APPT_APPOINTMENT_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT 
		a.*
	FROM 
		[CRS].[vw_APPT_APPOINTMENT] a
			inner join CRS.SPATIENT s on a.patientsid=s.patientsid
			inner join CRS.PATIENT p on s.patienticn=p.patienticn
			inner join CRS.REFERRAL r on p.patient_id=r.patient_id
	WHERE r.REFERRAL_ID = @REFERRAL_ID
	ORDER BY a.APPOINTMENTDATETIME

END

' 
END
GO

-------------------------------
--Add Appointments as CORE Type
-------------------------------

if not exists(select * from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Appointments')
begin
	insert into CRS.STD_REGISTRY_CORE_TYPES (TABLE_NAME,CODE,NAME,DESCRIPTION_TEXT,CREATEDBY,UPDATEDBY,CREATED,UPDATED,DEFAULT_FLAG) 
	values ('APPT_APPOINTMENT','Appointments','Appointments','Appointments','InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,1);
end
go

---------------------------------
--Associate Appointments with KDR
---------------------------------

if exists(select ID from CRS.STD_REGISTRY where CODE='KDR')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='KDR') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Appointments'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='KDR'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Appointments'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,1);
	end
end
go

----------------------------
--Add Encounter as CORE Type
----------------------------

if not exists(select * from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Encounter')
begin
	insert into CRS.STD_REGISTRY_CORE_TYPES (TABLE_NAME,CODE,NAME,DESCRIPTION_TEXT,CREATEDBY,UPDATEDBY,CREATED,UPDATED,DEFAULT_FLAG) 
	values ('ENC_ENCOUNTER','Encounter','Encounter','Encounter','InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,1);
end
go

--------------------------------------------------
--Associate Encounter with the existing Registries
--------------------------------------------------

if exists(select ID from CRS.STD_REGISTRY where CODE='KDR')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='KDR') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Encounter'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='KDR'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Encounter'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0);
	end
end
go

if exists(select ID from CRS.STD_REGISTRY where CODE='TR')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='TR') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Encounter'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='TR'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Encounter'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0);
	end
end
go

if exists(select ID from CRS.STD_REGISTRY where CODE='AR')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='AR') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Encounter'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='AR'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Encounter'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0);
	end
end
go

if exists(select ID from CRS.STD_REGISTRY where CODE='HR')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='HR') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Encounter'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='HR'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Encounter'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0);
	end
end
go

if exists(select ID from CRS.STD_REGISTRY where CODE='ONC')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='ONC') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Encounter'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='ONC'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Encounter'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0);
	end
end
go

---------------------------------
--Add Patient - Race as CORE Type
---------------------------------

if not exists(select * from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Race')
begin
	insert into CRS.STD_REGISTRY_CORE_TYPES (TABLE_NAME,CODE,NAME,DESCRIPTION_TEXT,CREATEDBY,UPDATEDBY,CREATED,UPDATED,DEFAULT_FLAG) 
	values ('PATSUB_PATIENTRACE','Patient - Race','Patient - Race','Patient - Race','InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,1);
end
go

-------------------------------------------------------
--Associate Patient - Race with the existing Registries
-------------------------------------------------------

if exists(select ID from CRS.STD_REGISTRY where CODE='KDR')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='KDR') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Race'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='KDR'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Race'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0);
	end
end
go

if exists(select ID from CRS.STD_REGISTRY where CODE='TR')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='TR') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Race'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='TR'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Race'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0);
	end
end
go

if exists(select ID from CRS.STD_REGISTRY where CODE='AR')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='AR') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Race'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='AR'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Race'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0);
	end
end
go

if exists(select ID from CRS.STD_REGISTRY where CODE='HR')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='HR') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Race'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='HR'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Race'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0);
	end
end
go

if exists(select ID from CRS.STD_REGISTRY where CODE='ONC')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='ONC') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Race'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='ONC'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Race'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0);
	end
end
go

--------------------
--ADD KDR STOP CODES
--------------------
if NOT EXISTS(select COHORT_TYPE_ID from CRS.STD_REGISTRY_COHORT_TYPES t inner join CRS.REGISTRY_COHORT_DATA r on r.std_registry_cohort_type_id=t.cohort_type_id where r.std_registry_id=(select ID from CRS.STD_REGISTRY where CODE='KDR') and t.description_text='StopCode' and t.code in ('313','602','603','604','605','606','607','608'))
begin
	insert into CRS.REGISTRY_COHORT_DATA (std_registry_id,std_registry_cohort_type_id,createdby,updatedby,created,updated,selected_flag)
	select (select ID from CRS.STD_REGISTRY where CODE='KDR'),COHORT_TYPE_ID,'DNS      \DNS   BLANCT','DNS      \DNS   BLANCT',current_timestamp,current_timestamp,1 from CRS.STD_REGISTRY_COHORT_TYPES where description_text='StopCode' and code in ('313','602','603','604','605','606','607','608') order by COHORT_TYPE_ID
end

---------------------
--ADD KDR LOINC CODES
---------------------
if NOT EXISTS(select COHORT_TYPE_ID from CRS.STD_REGISTRY_COHORT_TYPES t inner join CRS.REGISTRY_COHORT_DATA r on r.std_registry_cohort_type_id=t.cohort_type_id where r.std_registry_id=(select ID from CRS.STD_REGISTRY where CODE='KDR') and t.description_text='LOINCCode' and t.code in ('11218-5','12842-1','14956-7','14957-5','1753-3','1754-1','1755-8','1757-4','18373-1','20454-5','21028-6','21059-1','21482-5','24355-0','24356-8','24357-6','24365-9','26801-1','27298-9','2887-8','2888-6','2889-4','30003-8','32209-9','32551-4','35663-4','39264-7','39265-4','40662-9','40663-7','43605-5','43606-3','43607-1','45060-1','49002-9','49023-5','50209-6','50554-5','50556-0','50561-0','50564-4','50749-1','50949-7','53121-0','53525-2','53530-2','53531-0','57019-2','57020-0','57369-1','57735-3','5804-0','58431-8','58448-2','58992-9','61196-2','63474-1'))
begin
	insert into CRS.REGISTRY_COHORT_DATA (std_registry_id,std_registry_cohort_type_id,createdby,updatedby,created,updated,selected_flag)
	select (select ID from CRS.STD_REGISTRY where CODE='KDR'),COHORT_TYPE_ID,'DNS      \DNS   BLANCT','DNS      \DNS   BLANCT',current_timestamp,current_timestamp,1 from CRS.STD_REGISTRY_COHORT_TYPES where description_text='LOINCCode' and code in ('11218-5','12842-1','14956-7','14957-5','1753-3','1754-1','1755-8','1757-4','18373-1','20454-5','21028-6','21059-1','21482-5','24355-0','24356-8','24357-6','24365-9','26801-1','27298-9','2887-8','2888-6','2889-4','30003-8','32209-9','32551-4','35663-4','39264-7','39265-4','40662-9','40663-7','43605-5','43606-3','43607-1','45060-1','49002-9','49023-5','50209-6','50554-5','50556-0','50561-0','50564-4','50749-1','50949-7','53121-0','53525-2','53530-2','53531-0','57019-2','57020-0','57369-1','57735-3','5804-0','58431-8','58448-2','58992-9','61196-2','63474-1') order by COHORT_TYPE_ID
end

/****** Object:  View [CRS].[vw_ICD9_ComorbidCondition]    Script Date: 5/11/2018 9:24:20 AM ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[CRS].[vw_ICD9_ComorbidCondition]'))
DROP VIEW [CRS].[vw_ICD9_ComorbidCondition]
GO

/****** Object:  View [CRS].[vw_ICD9_ComorbidCondition]    Script Date: 5/11/2018 9:24:20 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[CRS].[vw_ICD9_ComorbidCondition]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW  [CRS].[vw_ICD9_ComorbidCondition] AS 
SELECT [ICD9SID]
      ,[ICDIEN]
      ,[STA3N]
      ,[ICD9CODE]
      ,[ICD9Description]
      ,[DRGIDENTIFIER]
      ,[DRGCONDITIONCOMORBIDITYEXCLUSIONSID]
      ,[REPRODUCTIVESYSTEMMDC13FLAG]
      ,[MULTIPLESIGNIFICANTTRAUMAMDC24]
      ,[HIVMDC25]
      ,[EXPANDEDICDFLAG]
      ,[UNACCEPTABLEASPRIMARYFLAG]
      ,[DRGCONDITIONCOMORBIDITYEXCLUSIONIEN]
      ,[ICDCODINGSYSTEMIEN]
	  ,(CASE
			WHEN [ICD9CODE] in (''250.00'',''250.01'',''250.02'',''250.03'',''250.10'',''250.11'',''250.12'',''250.13'',''250.20'',''250.21'',''250.22'',''250.23'',''250.30'',''250.31'',''250.32'',''250.33'',''250.40'',''250.41'',''250.42'',''250.43'',''250.50'',''250.51'',''250.52'',''250.53'',''250.60'',''250.61'',''250.62'',''250.63'',''250.70'',''250.71'',''250.72'',''250.73'',''250.80'',''250.81'',''250.82'',''250.83'',''250.90'',''250.91'',''250.92'',''250.93'',''357.2'',''362.01'',''362.02'',''366.41'') THEN ''Diabetes''
			WHEN [ICD9CODE] in (''401.0'',''402.00'',''402.01'',''403.0'',''403.00'',''403.01'',''404.0'',''404.00'',''404.01'',''404.02'',''404.03'',''405.01'',''405.09'') THEN ''Hypertension''
			WHEN [ICD9CODE] in (''278.0'',''278.00'',''278.01'',''278.02'',''278.03'') THEN ''Obesity''
			WHEN [ICD9CODE] in (''042.'',''042.0'',''042.1'',''042.2'',''042.9'',''043.0'',''043.1'',''043.2'',''043.3'',''043.9'',''044.0'',''044.9'',''079.53'',''795.71'',''795.8'') THEN ''HIV''
			WHEN [ICD9CODE] in (''070.41'',''070.44'',''070.51'',''070.54'',''070.70'',''070.71'') THEN ''Hepatitis C''
			WHEN [ICD9CODE] in (''429.2'') THEN ''Cardiovascular Disease''
			ELSE ''Other''
	  END) as [GroupName]
FROM [CRS].[STD_ICD9_CODE]
WHERE
	[ICD9CODE] in (
		''250.00'',''250.01'',''250.02'',''250.03'',''250.10'',''250.11'',''250.12'',''250.13'',''250.20'',''250.21'',''250.22'',''250.23'',''250.30'',''250.31'',''250.32'',''250.33'',''250.40'',''250.41'',''250.42'',''250.43'',''250.50'',''250.51'',''250.52'',''250.53'',''250.60'',''250.61'',''250.62'',''250.63'',''250.70'',''250.71'',''250.72'',''250.73'',''250.80'',''250.81'',''250.82'',''250.83'',''250.90'',''250.91'',''250.92'',''250.93'',''357.2'',''362.01'',''362.02'',''366.41''
		,''401.0'',''402.00'',''402.01'',''403.0'',''403.00'',''403.01'',''404.0'',''404.00'',''404.01'',''404.02'',''404.03'',''405.01'',''405.09''
		,''278.0'',''278.00'',''278.01'',''278.02'',''278.03''
		,''042.'',''042.0'',''042.1'',''042.2'',''042.9'',''043.0'',''043.1'',''043.2'',''043.3'',''043.9'',''044.0'',''044.9'',''079.53'',''795.71'',''795.8''
		,''070.41'',''070.44'',''070.51'',''070.54'',''070.70'',''070.71''
		,''429.2''
	)
' 
GO

/****** Object:  View [CRS].[vw_ICD10_ComorbidCondition]    Script Date: 5/11/2018 9:25:26 AM ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[CRS].[vw_ICD10_ComorbidCondition]'))
DROP VIEW [CRS].[vw_ICD10_ComorbidCondition]
GO

/****** Object:  View [CRS].[vw_ICD10_ComorbidCondition]    Script Date: 5/11/2018 9:25:26 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[CRS].[vw_ICD10_ComorbidCondition]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW  [CRS].[vw_ICD10_ComorbidCondition] AS 
SELECT [ICD10SID]
      ,[ICDIEN]
      ,[STA3N]
      ,[ICD10CODE]
      ,[ICD10Description]
      ,[DRGIDENTIFIER]
      ,[DRGCONDITIONCOMORBIDITYEXCLUSIONSID]
      ,[REPRODUCTIVESYSTEMMDC13FLAG]
      ,[MULTIPLESIGNIFICANTTRAUMAMDC24]
      ,[HIVMDC25]
      ,[EXPANDEDICDFLAG]
      ,[UNACCEPTABLEASPRIMARYFLAG]
      ,[ICD10POAEXEMPTFLAG]
      ,[DRGCONDITIONCOMORBIDITYEXCLUSIONIEN]
      ,[ICDCODINGSYSTEMIEN]
	  ,(CASE
			WHEN [ICD10CODE] in (''E08.36'',''E08.42'',''E09.36'',''E09.42'',''E10.10'',''E10.11'',''E10.21'',''E10.29'',''E10.311'',''E10.319'',''E10.36'',''E10.37X1'',''E10.37X2'',''E10.37X3'',''E10.37X9'',''E10.39'',''E10.40'',''E10.42'',''E10.51'',''E10.618'',''E10.620'',''E10.621'',''E10.622'',''E10.628'',''E10.630'',''E10.638'',''E10.641'',''E10.649'',''E10.65'',''E10.69'',''E10.8'',''E10.9'',''E11.00'',''E11.01'',''E11.10'',''E11.11'',''E11.21'',''E11.29'',''E11.311'',''E11.319'',''E11.3591'',''E11.3592'',''E11.3593'',''E11.3599'',''E11.36'',''E11.39'',''E11.40'',''E11.42'',''E11.51'',''E11.618'',''E11.620'',''E11.621'',''E11.622'',''E11.628'',''E11.630'',''E11.638'',''E11.641'',''E11.649'',''E11.65'',''E11.69'',''E11.8'',''E11.9'',''E13.10'',''E13.36'',''E13.42'') THEN ''Diabetes''
			WHEN [ICD10CODE] in (''I10.'',''I11.0'',''I11.9'',''I12.0'',''I12.9'',''I13.0'',''I13.10'',''I13.11'',''I13.2'',''I15.0'',''I15.8'') THEN ''Hypertension''
			WHEN [ICD10CODE] in (''E66.01'',''E66.2'',''E66.3'',''E66.9'') THEN ''Obesity''
			WHEN [ICD10CODE] in (''B20.'',''B97.35'',''R75.'') THEN ''HIV''
			WHEN [ICD10CODE] in (''B17.10'',''B17.11'',''B18.2'',''B19.20'',''B19.21'') THEN ''Hepatitis C''
			WHEN [ICD10CODE] in (''I25.10'',''I25.110'',''I25.111'',''I25.118'',''I25.119'') THEN ''Cardiovascular Disease''
			ELSE ''Other''
	  END) as [GroupName]
FROM [CRS].[STD_ICD10_CODE]
WHERE
	[ICD10CODE] in (
		''E08.36'',''E08.42'',''E09.36'',''E09.42'',''E10.10'',''E10.11'',''E10.21'',''E10.29'',''E10.311'',''E10.319'',''E10.36'',''E10.37X1'',''E10.37X2'',''E10.37X3'',''E10.37X9'',''E10.39'',''E10.40'',''E10.42'',''E10.51'',''E10.618'',''E10.620'',''E10.621'',''E10.622'',''E10.628'',''E10.630'',''E10.638'',''E10.641'',''E10.649'',''E10.65'',''E10.69'',''E10.8'',''E10.9'',''E11.00'',''E11.01'',''E11.10'',''E11.11'',''E11.21'',''E11.29'',''E11.311'',''E11.319'',''E11.3591'',''E11.3592'',''E11.3593'',''E11.3599'',''E11.36'',''E11.39'',''E11.40'',''E11.42'',''E11.51'',''E11.618'',''E11.620'',''E11.621'',''E11.622'',''E11.628'',''E11.630'',''E11.638'',''E11.641'',''E11.649'',''E11.65'',''E11.69'',''E11.8'',''E11.9'',''E13.10'',''E13.36'',''E13.42''
		,''I10.'',''I11.0'',''I11.9'',''I12.0'',''I12.9'',''I13.0'',''I13.10'',''I13.11'',''I13.2'',''I15.0'',''I15.8''
		,''E66.01'',''E66.2'',''E66.3'',''E66.9''
		,''B20.'',''B97.35'',''R75.''
		,''B17.10'',''B17.11'',''B18.2'',''B19.20'',''B19.21''
		,''I25.10'',''I25.110'',''I25.111'',''I25.118'',''I25.119''
	)
' 
GO


/***** Add Insurance to framework data options ******/
if not exists(select * from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Insurance')
begin
	insert into CRS.STD_REGISTRY_CORE_TYPES (TABLE_NAME,CODE,NAME,DESCRIPTION_TEXT,CREATEDBY,UPDATEDBY,CREATED,UPDATED,DEFAULT_FLAG) 
	values ('SPATIENT_SPATIENTINSURANCE','Patient - Insurance','Patient - Insurance','Patient - Insurance','InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,1);
end
go


/***** Add Insurance framework data to transplant registry ******/
if exists(select ID from CRS.STD_REGISTRY where CODE='TR')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='TR') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Insurance'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='TR'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Patient - Insurance'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,1);
	end
end
